let uploadsChart = $('#uploads-chart');
if (uploadsChart.length) {
    const charts = {
        initUploads: function() { this.uploadsChartsData() },
        uploadsChartsData: function() {
            const dataUrl = getConfig.baseURL + '/user/dashboard/charts/uploads';
            const request = $.ajax({
                method: 'GET',
                url: dataUrl
            });
            request.done(function(response) {
                charts.createUploadsCharts(response);
            });
        },
        createUploadsCharts: function(response) {
            const max = response.suggestedMax;
            const labels = response.uploadsChartLabels;
            const data = response.uploadsChartData;
            window.Chart && (new Chart(uploadsChart, {
                type: 'bar',
                data: {
                    labels: labels,
                    datasets: [{
                        label: 'Uploads',
                        data: data,
                        fill: true,
                        tension: 0.3,
                        backgroundColor: getConfig.primaryColor,
                        borderColor: getConfig.primaryColor,
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            display: false,
                        }
                    },
                    scales: {
                        y: {
                            suggestedMax: max,
                        }
                    }
                }
            })).render();
        },
    };
    charts.initUploads();
}