(function($) {
    "use strict";
    // Get Current Year
    document.querySelectorAll('[data-year]').forEach(function(el) {
        el.textContent = new Date().getFullYear();
    });

    // AOS
    if ($('[data-aos]').length > 0) {
        AOS.init({ once: true, disable: 'mobile' });
    }

    let otpCode = $('#otp-code');
    if (otpCode.length) {
        otpCode.on('input', function() {
            this.value = this.value.replace(/\D/g, '');
        });
    }

    if (window.location.hash === "#_=_") {
        if (history.replaceState) {
            var cleanHref = window.location.href.split("#")[0];
            history.replaceState(null, null, cleanHref);
        } else {
            window.location.hash = "";
        }
    }

    // Dropdown
    var dropdown = document.querySelectorAll('[data-dropdown]');
    if (dropdown != null) {
        dropdown.forEach(function(el) {
            function dropdownOP() {
                if (el.getBoundingClientRect().top + el.querySelector(".drop-down-menu").offsetHeight > window.innerHeight - 60) {
                    el.querySelector(".drop-down-menu").style.top = "auto";
                    el.querySelector(".drop-down-menu").style.bottom = "40px";
                } else {
                    el.querySelector(".drop-down-menu").style.top = "40px";
                    el.querySelector(".drop-down-menu").style.bottom = "auto";
                }
            }
            window.addEventListener("click", function(e) {
                if (el.contains(e.target)) {
                    el.classList.toggle('active');
                    setTimeout(function() {
                        el.classList.toggle('animated');
                    }, 0);
                } else {
                    el.classList.remove('active');
                    el.classList.remove('animated');
                }
                dropdownOP();
            });
            window.addEventListener("resize", dropdownOP);
            window.addEventListener("scroll", dropdownOP);
        });
    }

    // Scroll To
    let links = document.querySelectorAll('[data-link]');
    if (links) {
        links.forEach((el) => {
            el.onclick = (e) => {
                e.preventDefault();
                var scrollTarget = document.querySelector(el.getAttribute('data-link')).offsetTop - 65;
                console.log(scrollTarget);
                window.scrollTo('0', scrollTarget);
                navbarMenu.classList.remove("show");
                document.body.classList.remove("overflow-hidden");
            };
        });
    }

    // Navbar Menu
    let navbarMenu = document.querySelector(".nav-bar-menu"),
        navbarMenuBtn = document.querySelector(".nav-bar-menu-btn");
    if (navbarMenu) {
        let navbarMenuClose = navbarMenu.querySelector(".nav-bar-menu-close"),
            navbarMenuOverlay = navbarMenu.querySelector(".overlay"),
            navUploadBtn = document.querySelector(".nav-bar-menu [data-upload-btn]");
        navbarMenuBtn.onclick = () => {
            navbarMenu.classList.add("show");
            document.body.classList.add("overflow-hidden");
        };

        navbarMenuClose.onclick = navbarMenuOverlay.onclick = () => {
            navbarMenu.classList.remove("show");
            document.body.classList.remove("overflow-hidden");
        };
        if (navUploadBtn) {
            navUploadBtn.addEventListener("click", () => {
                navbarMenu.classList.remove("show");
            });
        }
    }

    let confirmActionLink = $('.confirm-action');
    confirmActionLink.on('click', function(e) {
        e.preventDefault();
        Swal.fire({
            title: getConfig.alertActionTitle,
            text: getConfig.alertActionText,
            icon: 'question',
            showCancelButton: true,
            allowOutsideClick: false,
            focusConfirm: false,
            confirmButtonText: getConfig.alertActionConfirmButton,
            confirmButtonColor: getConfig.primaryColor,
            cancelButtonText: getConfig.alertActionCancelButton,
        }).then((result) => {
            if (result.isConfirmed) {
                location.href = $(this).attr('href');
            }
        })
    });

    let confirmFormBtn = $('.confirm-action-form');
    confirmFormBtn.on('click', function(e) {
        e.preventDefault();
        Swal.fire({
            title: getConfig.alertActionTitle,
            text: getConfig.alertActionText,
            icon: 'question',
            showCancelButton: true,
            allowOutsideClick: false,
            focusConfirm: false,
            confirmButtonText: getConfig.alertActionConfirmButton,
            confirmButtonColor: getConfig.primaryColor,
            cancelButtonText: getConfig.alertActionCancelButton,
        }).then((result) => {
            if (result.isConfirmed) {
                $(this).parents('form')[0].submit();
            }
        })
    });

    // Password Input
    let password = document.querySelectorAll(".input-password");
    if (password) {
        password.forEach((el) => {
            let passwordBtn = el.querySelector("button"),
                passwordInput = el.querySelector("input");
            passwordBtn.onclick = (e) => {
                e.preventDefault();
                if (passwordInput.type === "password") {
                    passwordInput.type = "text";
                    passwordBtn.innerHTML = `<i class="fas fa-eye-slash"></i>`;
                } else {
                    passwordInput.type = "password";
                    passwordBtn.innerHTML = `<i class="fas fa-eye"></i>`;
                }
            };
        });
    }

    // Refresh
    let refresh = document.querySelectorAll("[data-refresh]");
    if (refresh) {
        refresh.forEach((el) => {
            el.onclick = () => {
                location.reload();
            };
        });
    }

    // Clipboard
    let clipboardBtn = document.querySelectorAll(".btn-copy");
    if (clipboardBtn) {
        clipboardBtn.forEach((el) => {
            let clipboard = new ClipboardJS(el);
            clipboard.on("success", () => {
                toastr.success(getConfig.copiedToClipboardSuccess);
            });
        });
    }

    // Fileviewer
    let fileviewer = document.querySelector(".fileviewer"),
        fileviewerSidebar = document.querySelector(".fileviewer-sidebar");
    if (fileviewerSidebar) {
        let fileviewerSidebarOpen = document.querySelector(".fileviewer-sidebar-open"),
            fileviewerSidebarClose = document.querySelector(".fileviewer-sidebar-close"),
            fileviewerSidebarOverlay = document.querySelector(".fileviewer-sidebar .overlay");
        fileviewerSidebarOpen.onclick = () => {
            fileviewer.classList.add("toggle");
        };
        fileviewerSidebarClose.onclick = fileviewerSidebarOverlay.onclick = () => {
            fileviewer.classList.remove("toggle");
        };
        window.addEventListener("resize", () => { fileviewer.classList.remove("toggle") });
    }

    // File Check
    let files = document.querySelectorAll(".filemanager-file"),
        filesActions = document.querySelector(".filemanager-actions"),
        fileSelectAll = document.querySelector(".filemanager-select-all"),
        filesArray = [];
    if (files) {
        files.forEach((el) => {
            let fileCheckbox = el.querySelector(".form-check-input"),
                fileLinks = el.querySelectorAll(".filemanager-link"),
                fileDropdown = el.querySelector(".drop-down"),
                checkStat = false;

            function checkSelectedFiles() {
                let filesSelected = document.querySelectorAll(
                    ".filemanager-file.selected"
                );
                if (filesSelected.length > 0) {
                    filesActions.classList.add("show");
                } else {
                    filesActions.classList.remove("show");
                }
                if (filesSelected.length === files.length) {
                    fileSelectAll.checked = true;
                    fileSelectAll.nextElementSibling.textContent =
                        fileSelectAll.parentNode.getAttribute("data-unselect");
                } else {
                    fileSelectAll.checked = false;
                    fileSelectAll.nextElementSibling.textContent =
                        fileSelectAll.parentNode.getAttribute("data-select");
                }
                files.forEach((ele) => {
                    if (ele.querySelector(".form-check-input").checked === true) {
                        filesArray.push(ele.querySelector(".form-check-input").id);
                        let uniquefilesArray = [...new Set(filesArray)];
                        filesSelectedInput.value = uniquefilesArray.sort();
                    } else {
                        filesArray = filesArray.filter(function(item) {
                            return item !== ele.querySelector(".form-check-input").id;
                        });
                        let uniquefilesArray = [...new Set(filesArray)];
                        filesSelectedInput.value = uniquefilesArray;
                    }
                });
            }
            fileCheckbox.onchange = () => {
                if (fileCheckbox.checked === true) {
                    el.classList.add("selected");
                    checkStat = fileCheckbox.checked;
                } else {
                    el.classList.remove("selected");
                    checkStat = fileCheckbox.checked;
                }
                checkSelectedFiles();
            };
            el.onclick = () => {
                if (fileCheckbox.checked === true) {
                    fileCheckbox.checked = false;
                    el.classList.remove("selected");
                    checkStat = fileCheckbox.checked;
                } else {
                    fileCheckbox.checked = true;
                    el.classList.add("selected");
                    checkStat = fileCheckbox.checked;
                }
                checkSelectedFiles();
            };
            fileDropdown.onclick = () => {
                if (fileCheckbox.checked === true) {
                    fileCheckbox.checked = false;
                    el.classList.remove("selected");
                    checkStat = fileCheckbox.checked;
                } else {
                    fileCheckbox.checked = true;
                    el.classList.add("selected");
                    checkStat = fileCheckbox.checked;
                }
            };
            fileCheckbox.onclick = (e) => {
                e.stopPropagation();
            };
            if (fileLinks) {
                fileLinks.forEach((link) => {
                    link.onclick = (e) => {
                        e.stopPropagation();
                    };
                });
            }
            fileSelectAll.onchange = () => {
                if (fileSelectAll.checked === true) {
                    files.forEach((el) => {
                        el.querySelector(".form-check-input").checked = true;
                        el.classList.add("selected");
                        checkStat = fileCheckbox.checked;
                    });
                } else {
                    files.forEach((el) => {
                        el.querySelector(".form-check-input").checked = false;
                        filesActions.classList.remove("show");
                        el.classList.remove("selected");
                        checkStat = fileCheckbox.checked;
                    });
                }
                checkSelectedFiles();
            };
        });
    }

    let avatarInput = $('#change_avatar'),
        targetedImagePreview = $('#avatar_preview');
    avatarInput.on('change', function() {
        var file = true,
            readLogoURL;
        if (file) {
            readLogoURL = function(input_file) {
                if (input_file.files && input_file.files[0]) {
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        targetedImagePreview.attr('src', e.target.result);
                    }
                    reader.readAsDataURL(input_file.files[0]);
                }
            }
        }
        readLogoURL(this);
    });

    let deleteFile = $('.delete-file');
    deleteFile.on('click', function(e) {
        e.preventDefault();
        var id = $(this).data('id');
        Swal.fire({
            title: getConfig.alertActionTitle,
            text: getConfig.alertActionText,
            icon: 'question',
            showCancelButton: true,
            allowOutsideClick: false,
            focusConfirm: false,
            confirmButtonText: getConfig.alertActionConfirmButton,
            confirmButtonColor: getConfig.primaryColor,
            cancelButtonText: getConfig.alertActionCancelButton,
        }).then((result) => {
            if (result.isConfirmed) {
                document.getElementById('deleteFile' + id).submit();
            }
        })
    });

    let fileManagerShareFile = $('.fileManager-share-file'),
        shareModal = $('#shareModal'),
        shareModalSocialIcons = $('.share-modal .share'),
        shareModalLinkInput = $('.share-modal #copy-share-link'),
        shareModalFileName = $('.share-modal .filename');
    if (fileManagerShareFile.length) {
        fileManagerShareFile.on('click', function(e) {
            e.preventDefault();
            let share = $(this).data('share'),
                facebook = "https://www.facebook.com/sharer/sharer.php?u=" + share.share_link,
                twitter = "https://twitter.com/intent/tweet?text=" + share.share_link,
                whatsapp = "https://wa.me/?text=" + share.share_link,
                linkedin = "https://www.linkedin.com/shareArticle?mini=true&url=" + share.share_link,
                pinterest = "http://pinterest.com/pin/create/button/?url=" + share.share_link;
            shareModalFileName.html('<strong>' + share.filename + '</strong>');
            shareModalSocialIcons.html('<a href="' + facebook + '" target="_blank" class="social-btn social-facebook"><i class="fab fa-facebook-f"></i></a> <a href="' + twitter + '" target="_blank" class="social-btn social-twitter"><i class="fab fa-twitter"></i></a> <a href="' + whatsapp + '" target="_blank" class="social-btn social-whatsapp"><i class="fab fa-whatsapp"></i></a> <a href="' + linkedin + '" target="_blank" class="social-btn social-linkedin"><i class="fab fa-linkedin"></i></a> <a href="' + pinterest + '" target="_blank" class="social-btn social-pinterest"><i class="fab fa-pinterest"></i></a>');
            shareModalLinkInput.attr('value', share.share_link);
            shareModal.modal('show');
        });
    }


})(jQuery);