<?php

namespace Vuehoucine\Trustlicence\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class HandlerController extends Controller
{
    public function redirect()
    {return redirect()->route('install.requirements');}
    public function redirectToDatabase()
    {return redirect()->route('install.information.database');}
    protected function extensionsArray()
    {
        $extensions = phpExtensions();
        $extensionsArray = [];
        foreach ($extensions as $extension) {$extensionsArray[] = extensionAvailability($extension);}
        return $extensionsArray;
    }
    public function requirements()
    {
        if (env('VIRONEER_REQUIREMENTS')) {return redirect()->route('install.permissions');}
        $error = 0;
        $extensions = phpExtensions();
        if (in_array(false, $this->extensionsArray())) {
            $error = 1;
        }
        return view('trustlicence::requirements', ['extensions' => $extensions, 'error' => $error]);
    }
    public function requirementsAction(Request $request)
    {
        if (in_array(false, $this->extensionsArray())) {return redirect()->route('install.requirements');}
        \Artisan::call('key:generate');
        setEnv('APP_ENV', 'production');
        setEnv('VIRONEER_REQUIREMENTS', 1);
        return redirect()->route('install.permissions');
    }
    protected function permissionsArray()
    {
        $permissions = filePermissions();
        $permissionsArray = [];
        foreach ($permissions as $permission) {
            $permissionsArray[] = filePermissionValidation($permission);
        }
        return $permissionsArray;
    }
    public function permissions()
    {
        if (env('VIRONEER_FILEPERMISSIONS')) {return redirect()->route('install.licence');}
        if (!env('VIRONEER_REQUIREMENTS')) {return redirect()->route('install.requirements');}
        $error = 0;
        $permissions = filePermissions();
        if (in_array(false, $this->permissionsArray())) {
            $error = 1;
        }
        return view('trustlicence::permissions', ['permissions' => $permissions, 'error' => $error]);
    }
    public function permissionsAction(Request $request)
    {
        if (in_array(false, $this->permissionsArray())) {return redirect()->route('install.permissions');}
        setEnv('VIRONEER_FILEPERMISSIONS', 1);
        return redirect()->route('install.licence');
    }
    public function licence()
    {
        if (env('VIRONEER_LICENCE')) {return redirect()->route('install.information.database');}
        if (!env('VIRONEER_FILEPERMISSIONS')) {return redirect()->route('install.requirements');}
        return view('trustlicence::licence');
    }
    public function licenceAction(Request $request)
    {
        setEnv('VIRONEER_LICENCE', 1);
        return redirect()->route('install.information.database');
    }
    public function database()
    {
        if (env('VIRONEER_INFODATABASE')) {return redirect()->route('install.information.databaseImport');}
        if (!env('VIRONEER_LICENCE')) {return redirect()->route('install.licence');}
        return view('trustlicence::information.database');
    }

    public function databaseAction(Request $request)
    {
		$validator = Validator::make($request->all(), [
            'db_host' => ['required', 'string'],
            'db_name' => ['required', 'string'],
            'db_user' => ['required', 'string'],
        ]);
        if ($validator->fails()) {return redirect()->back()->withErrors($validator)->withInput();}
        if (!function_exists('curl_version')) {return redirect()->back()->withErrors(['CURL does not exist in server'])->withInput();}
        if (!is_writable(base_path('.env'))) {return redirect()->back()->withErrors(['.ENV file is not writable'])->withInput();}
        if (!@mysqli_connect($request->db_host, $request->db_user, $request->db_pass, $request->db_name)) {return redirect()->back()->withErrors(['Incorrect database information'])->withInput();}
        if (!file_exists(base_path('database/sql/data.sql'))) {return redirect()->back()->withErrors(['SQL file is missing'])->withInput();}
        setEnv('DB_HOST', $request->db_host);
        setEnv('DB_DATABASE', $request->db_name);
        setEnv('DB_USERNAME', $request->db_user);
        setEnv('DB_PASSWORD', $request->db_pass);
        setEnv('VIRONEER_INFODATABASE', 1);
        return redirect()->route('install.information.databaseImport');
    }
    public function databaseImport()
    {
        if (env('VIRONEER_INFODBIMPORT')) {return redirect()->route('install.information.building');}
        if (!env('VIRONEER_INFODATABASE')) {return redirect()->route('install.information.database');}
        return view('trustlicence::information.databaseImport');
    }
    public function databaseImportAction(Request $request)
    {
        try {
            DB::connection()->getPdo();
            if (DB::connection()->getDatabaseName()) {
                $sql = base_path('database/sql/data.sql');
                $import = DB::unprepared(file_get_contents($sql));
                if ($import) {
                    setEnv('VIRONEER_INFODBIMPORT', 1);
                    return redirect()->route('install.information.building');
                } else {
                    return redirect()->back()->withErrors(['Error']);
                }
            } else {
                return redirect()->back()->withErrors(['Could not find the database. Please check your configuration.']);
            }
        } catch (\Exception $e) {
            return redirect()->back()->withErrors([$e->getMessage()]);
        }
    }
    public function downloadSqlFile()
    {
        $sql = base_path('database/sql/data.sql');
        if (!file_exists($sql)) {
            return redirect()->back()->withErrors(['SQL file missing']);
        }
        return response()->download($sql);
    }
    public function databaseImportSkip()
    {
        setEnv('VIRONEER_INFODBIMPORT', 1);
        return redirect()->route('install.information.building');
    }
    public function building()
    {
        if (env('VIRONEER_INFOBUILDING')) {return redirect('/');}
        if (!env('VIRONEER_INFODBIMPORT')) {return redirect()->route('install.information.databaseImport');}
        return view('trustlicence::information.building');
    }
    public function backToDatabaseImport()
    {
        setEnv('VIRONEER_INFODBIMPORT', '');
        return redirect()->route('install.information.database');
    }
    public function buildingAction(Request $request)
    {
		$validator = \Validator::make($request->all(), [
            'firstname' => ['required', 'string', 'max:255'],
            'lastname' => ['required', 'string', 'max:255'],
            'website_name' => ['required', 'string', 'max:200'],
            'website_url' => ['required', 'url'],
            'email' => ['required', 'string', 'email', 'unique:admins'],
            'password' => ['required', 'string', 'min:8', 'confirmed'],
        ]);
        if ($validator->fails()) {return redirect()->back()->withErrors($validator)->withInput();}
        $avatar = 'images/avatars/default.png';
        $createAdmin = \App\Models\Admin::create([
            'firstname' => $request->firstname,
            'lastname' => $request->lastname,
            'email' => $request->email,
            'password' => bcrypt($request->password),
            'avatar' => $avatar,
        ]);
        if ($createAdmin) {
            $settings = \App\Models\Settings::whereIn('key', ['website_name', 'website_url'])->get();
            foreach ($settings as $setting) {
                $key = $setting->key;
                $setting->value = $request->$key;
                $setting->save();
            }
            setEnv('APP_URL', $request->website_url);
            setEnv('VIRONEER_INFOBUILDING', 1);
            setEnv('VIRONEER_SYSTEMSTATUS', 1);
            return redirect()->route('admin.index');
        }
    }
}
